/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "board.h"
#include "fsl_debug_console.h"
#include "fsl_gpio.h"

#include "pin_mux.h"
#include <stdbool.h>
/*******************************************************************************
 * Definitions
 ******************************************************************************/

#define APP_BOARD_TEST_GPIO_PORT1 BOARD_LED1_GPIO_PORT
#define APP_BOARD_TEST_GPIO_PORT2 BOARD_LED2_GPIO_PORT
#define APP_BOARD_TEST_GPIO_PORT3 BOARD_LED3_GPIO_PORT
#define APP_BOARD_TEST_LED1_PIN BOARD_LED1_GPIO_PIN
#define APP_BOARD_TEST_LED2_PIN BOARD_LED2_GPIO_PIN
#define APP_BOARD_TEST_LED3_PIN BOARD_LED3_GPIO_PIN
#define APP_SW1_PORT BOARD_SW2_GPIO_PORT
#define APP_SW2_PORT BOARD_SW3_GPIO_PORT
#define APP_SW3_PORT BOARD_SW4_GPIO_PORT
#define APP_SW4_PORT BOARD_SW5_GPIO_PORT
#define APP_SW1_PIN BOARD_SW2_GPIO_PIN
#define APP_SW2_PIN BOARD_SW3_GPIO_PIN
#define APP_SW3_PIN BOARD_SW4_GPIO_PIN
#define APP_SW4_PIN BOARD_SW5_GPIO_PIN

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
/*!
 * @brief delay a while.
 */
void delay(void);

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/
void delay(void)
{
    volatile uint32_t i = 0;
    for (i = 0; i < 100000; ++i)
    {
        __asm("NOP"); /* delay */
    }
}

/*!
 * @brief Main function
 */
int main(void)
{
	int cnt;
	int delays;
	int i;
	int regular;
    /* Define the init structure for the output LED pin*/
    gpio_pin_config_t led_config = {
        kGPIO_DigitalOutput, 0,
    };

    /* Board pin, clock, debug console init */
    /* attach 12 MHz clock to FLEXCOMM0 (debug console) */
    CLOCK_AttachClk(BOARD_DEBUG_UART_CLK_ATTACH);
    CLOCK_EnableClock(kCLOCK_Gpio0);
    CLOCK_EnableClock(kCLOCK_Gpio1);
    CLOCK_EnableClock(kCLOCK_Gpio2);
    CLOCK_EnableClock(kCLOCK_Gpio3);

    BOARD_InitPins();
    BOARD_BootClockFROHF48M();
    BOARD_InitDebugConsole();

    /* Print a note to terminal. */
    PRINTF("LPCXpresso54618 application example\r\n\r\n");
    PRINTF("Use push buttons SW2 and SW3 to speed up or slow down the running LED light.\r\n");
    PRINTF("Use push button SW4 to toggle between running LED light and inverted running light.\r\n");
    PRINTF("Use push button SW5 to reset the chip and start the ESAcademy bootloader, if present.\r\n\r\n");

    /* Init output LED GPIO. */
    GPIO_PinInit(GPIO, APP_BOARD_TEST_GPIO_PORT1, APP_BOARD_TEST_LED1_PIN, &led_config);
    GPIO_WritePinOutput(GPIO, APP_BOARD_TEST_GPIO_PORT1, APP_BOARD_TEST_LED1_PIN, 1);

    GPIO_PinInit(GPIO, APP_BOARD_TEST_GPIO_PORT2, APP_BOARD_TEST_LED2_PIN, &led_config);
    GPIO_WritePinOutput(GPIO, APP_BOARD_TEST_GPIO_PORT2, APP_BOARD_TEST_LED2_PIN, 1);

    GPIO_PinInit(GPIO, APP_BOARD_TEST_GPIO_PORT3, APP_BOARD_TEST_LED3_PIN, &led_config);
    GPIO_WritePinOutput(GPIO, APP_BOARD_TEST_GPIO_PORT3, APP_BOARD_TEST_LED3_PIN, 1);

    GPIO_ClearPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT2, 1 << APP_BOARD_TEST_LED2_PIN);
    GPIO_ClearPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT3, 1 << APP_BOARD_TEST_LED3_PIN);

    regular = true;
	cnt = 0;
	delays = 10;
    for (;;)
    {
		if (regular)
		{
			if (cnt==0)
			{
				GPIO_SetPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT3, 1 << APP_BOARD_TEST_LED3_PIN);
				GPIO_ClearPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT1, 1 << APP_BOARD_TEST_LED1_PIN);
			}
			else if (cnt==1)
			{
				GPIO_SetPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT1, 1 << APP_BOARD_TEST_LED1_PIN);
				GPIO_ClearPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT2, 1 << APP_BOARD_TEST_LED2_PIN);
			}
			else if (cnt==2)
			{
				GPIO_SetPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT2, 1 << APP_BOARD_TEST_LED2_PIN);
				GPIO_ClearPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT3, 1 << APP_BOARD_TEST_LED3_PIN);
			}
		}
		else
		{
			if (cnt==0)
			{
				GPIO_SetPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT1, 1 << APP_BOARD_TEST_LED1_PIN);
				GPIO_ClearPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT3, 1 << APP_BOARD_TEST_LED3_PIN);
			}
			else if (cnt==1)
			{
				GPIO_SetPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT2, 1 << APP_BOARD_TEST_LED2_PIN);
				GPIO_ClearPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT1, 1 << APP_BOARD_TEST_LED1_PIN);
			}
			else if (cnt==2)
			{
				GPIO_SetPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT3, 1 << APP_BOARD_TEST_LED3_PIN);
				GPIO_ClearPinsOutput(GPIO, APP_BOARD_TEST_GPIO_PORT2, 1 << APP_BOARD_TEST_LED2_PIN);
			}
		}
		cnt++;
		if (cnt==3)
			cnt = 0;

		if (!GPIO_ReadPinInput(GPIO, APP_SW1_PORT, APP_SW1_PIN))
		{
			if (delays>2)
				delays--;
		}
		if (!GPIO_ReadPinInput(GPIO, APP_SW2_PORT, APP_SW2_PIN))
		{
			if (delays<20)
				delays++;
		}
		if (!GPIO_ReadPinInput(GPIO, APP_SW3_PORT, APP_SW3_PIN))
		{
			regular = !regular;
		}
		if (!GPIO_ReadPinInput(GPIO, APP_SW4_PORT, APP_SW4_PIN))
		{
			// reset (and start bootloader if present) when SW5 is pressed
			*((unsigned int *)0x20027FFCUL) = 0x21654387UL;  // set bootloader flag
			NVIC_SystemReset();
		}

		for (i=0; i<delays; i++)
			delay();
    }
}
