/**************************************************************************
MODULE:    USER_OD - Here: STANDARD USAGE OF GENERATED OD TABLES
CONTAINS:  MicroCANopen Object Dictionary and Process Image implementation
COPYRIGHT: (c) Embedded Systems Academy (EmSA) 2002-2019
           All rights reserved. www.em-sa.com/nxp
DISCLAIM:  Read and understand our disclaimer before using this code!
           www.esacademy.com/disclaim.htm
           This software was written in accordance to the guidelines at
           www.esacademy.com/software/softwarestyleguide.pdf
LICENSE:   THIS IS THE NXP SDK VERSION OF MICROCANOPEN PLUS
           Licensed under a modified BSD License. See LICENSE.INFO
           file in the project root for full license information.
VERSION:   7.00, EmSA 28-JUN-19
           $LastChangedDate: 2019-09-26 12:05:17 +0200 (Thu, 26 Sep 2019) $
           $LastChangedRevision: 4733 $
***************************************************************************/ 

#include "mcop_inc.h"

#include "entriesandreplies.h"


// The following lines fix different sizes of entries 
// auto-generated by CANopenArchitect EDS
#ifndef PIMGDEFAULTS2
#define PIMGDEFAULTS2
#endif
#ifndef PIMGDEFAULTS3
#define PIMGDEFAULTS3
#endif
#ifndef PIMGDEFAULTS4
#define PIMGDEFAULTS4
#endif
#ifndef SDOREPLY_ENTRIES2
#define SDOREPLY_ENTRIES2
#endif
#ifndef SDOREPLY_ENTRIES3
#define SDOREPLY_ENTRIES3
#endif
#ifndef SDOREPLY_ENTRIES4
#define SDOREPLY_ENTRIES4
#endif
#ifndef ODENTRY_ENTRIES2
#define ODENTRY_ENTRIES2
#endif
#ifndef ODENTRY_ENTRIES3
#define ODENTRY_ENTRIES3
#endif
#ifndef ODENTRY_ENTRIES4
#define ODENTRY_ENTRIES4
#endif


/**************************************************************************
GLOBAL VARIABLES
***************************************************************************/ 

uint8_t MEM_PROC gProcImg[PROCIMG_SIZE] = PIMGDEFAULTS PIMGDEFAULTS2 PIMGDEFAULTS3 PIMGDEFAULTS4;


// Table with SDO Responses for read requests to OD
uint8_t MEM_CONST gSDOResponseTable[] = {
// Each Row has 8 Bytes:
// Command Specifier for SDO Response (1 byte)
//   bits 2+3 contain: '4' – {number of data bytes}
// Object Dictionary Index (2 bytes, low first)
// Object Dictionary Subindex (1 byte)
// Data (4 bytes, lowest bytes first)

  // Include file generated by CANopen Architect
  SDOREPLY_ENTRIES SDOREPLY_ENTRIES2 SDOREPLY_ENTRIES3 SDOREPLY_ENTRIES4

  // End-of-table marker
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};


// Table with Object Dictionary entries to process Data
OD_PROCESS_DATA_ENTRY MEM_CONST gODProcTable[] = 
{
  // Include automatically generated files from CANopenArchitect EDS
  ODENTRY_ENTRIES ODENTRY_ENTRIES2 ODENTRY_ENTRIES3 ODENTRY_ENTRIES4

  // End-of-table marker
  ODENTRY(0xFFFF,0xFF,0xFF,0xFF)
};


#if USE_EXTENDED_SDO
// Table with generic entries to memory
OD_GENERIC_DATA_ENTRY MEM_CONST gODGenericTable[] = 
{
  ODGENTRY_ENTRIES

  ODGENTRYP(0xFFFF,0xFF,0xFF,0xFFFF,0xFFFF)
};
#endif // USE_EXTENDED_SDO


/**************************************************************************
END-OF-FILE 
***************************************************************************/ 
