/**************************************************************************
MODULE:    MAIN
CONTAINS:  Example application using MicroCANopen
           NXP i.MX RT 10xx derivatives with CAN interface.
COPYRIGHT: (c) Embedded Systems Academy (EmSA) 2002-2019
           All rights reserved. www.em-sa.com/nxp
DISCLAIM:  Read and understand our disclaimer before using this code!
           www.esacademy.com/disclaim.htm
           This software was written in accordance to the guidelines at
           www.esacademy.com/software/softwarestyleguide.pdf
LICENSE:   THIS IS THE NXP SDK VERSION OF MICROCANOPEN PLUS
           Licensed under a modified BSD License. See LICENSE.INFO
           file in the project root for full license information.
VERSION:   7.00, EmSA 28-JUN-19
           $LastChangedDate: 2019-10-01 02:03:15 +0200 (Tue, 01 Oct 2019) $
           $LastChangedRevision: 4761 $
***************************************************************************/
#include "canmain.h"


/**************************************************************************
GLOBAL VARIABLES
**************************************************************************/
// buffers to hold CANopen in and out data
unsigned char MCOUpdate = 0;
unsigned short analog_out;
unsigned char cos_ana_cnt; // change of state detection
signed short analog_out_last[4] = {0,0,0,0}; // copy of last received data

/**************************************************************************
DOES:    USER Process, here simple I/O example
RETURNS: nothing
**************************************************************************/
void USER_Process(void)
{

#if DEBUG_CONSOLE
#warning "Extended DEBUG_CONSOLE output enabled, delays execution"
char linebuf[200];
uint8_t print_info;
#endif

#if DEBUG_CONSOLE
  sprintf(linebuf," ");
  print_info = FALSE;
#endif

  // Process all output data from CANopen, COS change of state detection
  cos_ana_cnt = 0;

  MCO_ReadProcessData((uint8_t *)&(analog_out),2,P641101_Pos_X);
  if (analog_out != analog_out_last[0])
  { // ana out 1 changed, replace with own code reacting to output
    cos_ana_cnt++;
    analog_out_last[0] = analog_out;
#if DEBUG_CONSOLE
    sprintf(linebuf+strlen(linebuf), "[6411h,01h]:0x%04X ",analog_out);
    print_info = TRUE;
#endif
  }

  MCO_ReadProcessData((uint8_t *)&(analog_out),2,P641102_Pos_Y);
  if (analog_out != analog_out_last[1])
  { // ana out 2 changed, replace with own code reacting to output
    cos_ana_cnt++;
    analog_out_last[1] = analog_out;
#if DEBUG_CONSOLE
    sprintf(linebuf+strlen(linebuf), "[6411h,02h]:0x%04X ",analog_out);
    print_info = TRUE;
#endif
  }

  MCO_ReadProcessData((uint8_t *)&(analog_out),2,P641103_Pos_Z);
  if (analog_out != analog_out_last[2])
  { // ana out 2 changed, replace with own code reacting to output
    cos_ana_cnt++;
    analog_out_last[2] = analog_out;
#if DEBUG_CONSOLE
    sprintf(linebuf+strlen(linebuf), "[6411h,03h]:0x%04X ",analog_out);
    print_info = TRUE;
#endif
  }

  MCO_ReadProcessData((uint8_t *)&(analog_out),2,P222200_Counter);
  // Note: Counter is 32bit, here we only use 16 lower bits
  if (analog_out != analog_out_last[3])
  { // ana out 2 changed, replace with own code reacting to output
    cos_ana_cnt++;
    analog_out_last[3] = analog_out;
#if DEBUG_CONSOLE
    sprintf(linebuf+strlen(linebuf), "[6411h,04h]:0x%04X ",analog_out);
    print_info = TRUE;
#endif
  }

  if (cos_ana_cnt != 0)
  { // COS detection, new data arrived, stored in analog_out_last
	  MCOUpdate = 1;
  }

#if DEBUG_CONSOLE
  if (print_info)
	  PRINTF("\r\n%s", linebuf);
#endif

}


/*----------------------- END OF FILE ----------------------------------*/
