/*******************************************************************************
*
* E M B E D D E D   W I Z A R D   P R O J E C T
*
*                                                Copyright (c) TARA Systems GmbH
*                                    written by Paul Banach and Manfred Schweyer
*
********************************************************************************
*
* This file was generated automatically by Embedded Wizard Studio.
*
* Please do not make any modifications of this file! The modifications are lost
* when the file is generated again by Embedded Wizard Studio!
*
* The template of this heading text can be found in the file 'head.ewt' in the
* directory 'Platforms' of your Embedded Wizard installation directory. If you
* wish to adapt this text, please copy the template file 'head.ewt' into your
* project directory and edit the copy only. Please avoid any modifications of
* the original template file!
*
* Version  : 9.30
* Profile  : iMX_RT
* Platform : NXP.iMX_RT.RGB565
*
*******************************************************************************/

#include "ewlocale.h"
#include "_ApplicationApplication.h"
#include "_ApplicationDataGraph.h"
#include "_ApplicationDeviceClass.h"
#include "_ApplicationIndicator.h"
#include "_ApplicationOscilloscope.h"
#include "_CoreOutline.h"
#include "_CorePropertyObserver.h"
#include "_CoreRoot.h"
#include "_CoreSlideTouchHandler.h"
#include "_CoreTimer.h"
#include "_CoreView.h"
#include "_EffectsInt32Effect.h"
#include "_GraphicsPath.h"
#include "_ResourcesBitmap.h"
#include "_ResourcesFont.h"
#include "_ViewsImage.h"
#include "_ViewsRectangle.h"
#include "_ViewsStrokePath.h"
#include "_ViewsText.h"
#include "_ViewsWarpImage.h"
#include "Application.h"
#include "Core.h"
#include "Effects.h"
#include "Resources.h"
#include "Views.h"

/* Compressed strings for the language 'Default'. */
static const unsigned int _StringsDefault0[] =
{
  0x0000009C, /* ratio 76.92 % */
  0xB8004300, 0x80086452, 0x009C0020, 0x08C00168, 0x40002200, 0xA0029000, 0x0030800C,
  0x40042CD8, 0x001A4005, 0x04462A6D, 0xC80DF060, 0xB8007593, 0xCC6008F1, 0x58740045,
  0x00095C9A, 0x45818100, 0x89B4D4B0, 0x9BCECB33, 0xC4FCB504, 0x03276309, 0xBCE50E9C,
  0x2951690C, 0x6B1698C6, 0xD23A2022, 0x0038000C, 0x803CECE6, 0xAC55A253, 0x0CEE775A,
  0x00000008, 0x00000000
};

/* Constant values used in this 'C' module only. */
static const XRect _Const0000 = {{ 0, 0 }, { 480, 272 }};
static const XRect _Const0001 = {{ 10, 0 }, { 480, 30 }};
static const XStringRes _Const0002 = { _StringsDefault0, 0x0002 };
static const XRect _Const0003 = {{ 340, 50 }, { 370, 90 }};
static const XStringRes _Const0004 = { _StringsDefault0, 0x0023 };
static const XRect _Const0005 = {{ 340, 130 }, { 370, 170 }};
static const XStringRes _Const0006 = { _StringsDefault0, 0x0027 };
static const XRect _Const0007 = {{ 340, 210 }, { 370, 250 }};
static const XStringRes _Const0008 = { _StringsDefault0, 0x002B };
static const XRect _Const0009 = {{ 340, 97 }, { 470, 102 }};
static const XRect _Const000A = {{ 340, 177 }, { 470, 182 }};
static const XRect _Const000B = {{ 340, 257 }, { 470, 262 }};
static const XRect _Const000C = {{ 370, 50 }, { 470, 90 }};
static const XStringRes _Const000D = { _StringsDefault0, 0x002F };
static const XRect _Const000E = {{ 370, 130 }, { 470, 170 }};
static const XRect _Const000F = {{ 370, 210 }, { 470, 250 }};
static const XRect _Const0010 = {{ 380, 5 }, { 470, 25 }};
static const XStringRes _Const0011 = { _StringsDefault0, 0x0033 };
static const XRect _Const0012 = {{ 380, 25 }, { 470, 45 }};
static const XStringRes _Const0013 = { _StringsDefault0, 0x003F };
static const XPoint _Const0014 = { 0, 242 };
static const XRect _Const0015 = {{ 10, 30 }, { 312, 262 }};
static const XRect _Const0016 = {{ 10, 30 }, { 312, 102 }};
static const XColor _Const0017 = { 0xE8, 0xB4, 0x10, 0xFF };
static const XRect _Const0018 = {{ 10, 110 }, { 312, 182 }};
static const XColor _Const0019 = { 0x8B, 0xAE, 0xD9, 0xFF };
static const XRect _Const001A = {{ 10, 190 }, { 312, 262 }};
static const XColor _Const001B = { 0xC9, 0xD1, 0x21, 0xFF };
static const XRect _Const001C = {{ 10, 272 }, { 312, 504 }};
static const XColor _Const001D = { 0xE7, 0x00, 0x1F, 0xFF };
static const XRect _Const001E = {{ 10, 514 }, { 312, 746 }};
static const XStringRes _Const001F = { _StringsDefault0, 0x0047 };
static const XRect _Const0020 = {{ 0, 0 }, { 302, 232 }};
static const XColor _Const0021 = { 0x00, 0xFF, 0x06, 0xFF };
static const XPoint _Const0022 = { 150, 170 };
static const XPoint _Const0023 = { 210, 170 };
static const XPoint _Const0024 = { 210, 110 };
static const XPoint _Const0025 = { 150, 110 };
static const XPoint _Const0026 = { 20, 20 };
static const XColor _Const0027 = { 0xB2, 0xD3, 0x39, 0xFF };
static const XRect _Const0028 = {{ 0, 0 }, { 200, 20 }};
static const XRect _Const0029 = {{ 0, 0 }, { 300, 200 }};
static const XColor _Const002A = { 0x38, 0x38, 0x38, 0xFF };
static const XRect _Const002B = {{ 110, 50 }, { 210, 150 }};
static const XRect _Const002C = {{ 0, 0 }, { 302, 72 }};
static const XColor _Const002D = { 0xFF, 0xFF, 0xFF, 0xFF };
static const XRect _Const002E = {{ 1, 1 }, { 300, 70 }};
static const XColor _Const002F = { 0xFF, 0xFF, 0xFF, 0x80 };

/* This is an inline code block. */
/* include the device driver header file to get access for the device class */
#include "DeviceDriver.h"


/* Initializer for the class 'Application::Application' */
void ApplicationApplication__Init( ApplicationApplication _this, XObject aLink, XHandle aArg )
{
  /* At first initialize the super class ... */
  CoreRoot__Init( &_this->_Super, aLink, aArg );

  /* Allow the Immediate Garbage Collection to evalute the members of this class. */
  _this->_GCT = EW_CLASS_GCT( ApplicationApplication );

  /* ... then construct all embedded objects */
  ViewsImage__Init( &_this->Background, &_this->_XObject, 0 );
  ViewsText__Init( &_this->CaptionText, &_this->_XObject, 0 );
  ViewsText__Init( &_this->TextDescriptionMcoXValue, &_this->_XObject, 0 );
  ViewsText__Init( &_this->TextDescriptionMcoYValue, &_this->_XObject, 0 );
  ViewsText__Init( &_this->TextDescriptionMcoZValue, &_this->_XObject, 0 );
  CorePropertyObserver__Init( &_this->McoXValueObserver, &_this->_XObject, 0 );
  CorePropertyObserver__Init( &_this->McoYValueObserver, &_this->_XObject, 0 );
  CorePropertyObserver__Init( &_this->McoZValueObserver, &_this->_XObject, 0 );
  ApplicationIndicator__Init( &_this->Indicator, &_this->_XObject, 0 );
  ApplicationIndicator__Init( &_this->Indicator1, &_this->_XObject, 0 );
  ApplicationIndicator__Init( &_this->Indicator2, &_this->_XObject, 0 );
  ViewsText__Init( &_this->TextX, &_this->_XObject, 0 );
  ViewsText__Init( &_this->TextY, &_this->_XObject, 0 );
  ViewsText__Init( &_this->TextZ, &_this->_XObject, 0 );
  CoreTimer__Init( &_this->PerformanceTimer, &_this->_XObject, 0 );
  ViewsText__Init( &_this->FpsDescr, &_this->_XObject, 0 );
  ViewsText__Init( &_this->FpsText, &_this->_XObject, 0 );
  CoreSlideTouchHandler__Init( &_this->SlideTouchHandler, &_this->_XObject, 0 );
  CoreOutline__Init( &_this->Outline, &_this->_XObject, 0 );
  ApplicationDataGraph__Init( &_this->DataGraphX, &_this->_XObject, 0 );
  ApplicationDataGraph__Init( &_this->DataGraphY, &_this->_XObject, 0 );
  ApplicationDataGraph__Init( &_this->DataGraphZ, &_this->_XObject, 0 );
  ApplicationOscilloscope__Init( &_this->Oscilloscope, &_this->_XObject, 0 );
  ViewsImage__Init( &_this->Image, &_this->_XObject, 0 );

  /* Setup the VMT pointer */
  _this->_VMT = EW_CLASS( ApplicationApplication );

  /* ... and initialize objects, variables, properties, etc. */
  CoreRectView__OnSetBounds( _this, _Const0000 );
  CoreRectView__OnSetBounds( &_this->Background, _Const0000 );
  CoreRectView__OnSetBounds( &_this->CaptionText, _Const0001 );
  ViewsText_OnSetAlignment( &_this->CaptionText, ViewsTextAlignmentAlignHorzLeft 
  | ViewsTextAlignmentAlignVertCenter );
  ViewsText_OnSetString( &_this->CaptionText, EwLoadString( &_Const0002 ));
  CoreRectView__OnSetBounds( &_this->TextDescriptionMcoXValue, _Const0003 );
  ViewsText_OnSetWrapText( &_this->TextDescriptionMcoXValue, 1 );
  ViewsText_OnSetAlignment( &_this->TextDescriptionMcoXValue, ViewsTextAlignmentAlignHorzLeft 
  | ViewsTextAlignmentAlignVertCenter );
  ViewsText_OnSetString( &_this->TextDescriptionMcoXValue, EwLoadString( &_Const0004 ));
  CoreRectView__OnSetBounds( &_this->TextDescriptionMcoYValue, _Const0005 );
  ViewsText_OnSetWrapText( &_this->TextDescriptionMcoYValue, 1 );
  ViewsText_OnSetAlignment( &_this->TextDescriptionMcoYValue, ViewsTextAlignmentAlignHorzLeft 
  | ViewsTextAlignmentAlignVertCenter );
  ViewsText_OnSetString( &_this->TextDescriptionMcoYValue, EwLoadString( &_Const0006 ));
  CoreRectView__OnSetBounds( &_this->TextDescriptionMcoZValue, _Const0007 );
  ViewsText_OnSetWrapText( &_this->TextDescriptionMcoZValue, 1 );
  ViewsText_OnSetAlignment( &_this->TextDescriptionMcoZValue, ViewsTextAlignmentAlignHorzLeft 
  | ViewsTextAlignmentAlignVertCenter );
  ViewsText_OnSetString( &_this->TextDescriptionMcoZValue, EwLoadString( &_Const0008 ));
  CoreRectView__OnSetBounds( &_this->Indicator, _Const0009 );
  ApplicationIndicator_OnSetCurrentValue( &_this->Indicator, -2000 );
  CoreRectView__OnSetBounds( &_this->Indicator1, _Const000A );
  ApplicationIndicator_OnSetCurrentValue( &_this->Indicator1, -2000 );
  CoreRectView__OnSetBounds( &_this->Indicator2, _Const000B );
  ApplicationIndicator_OnSetCurrentValue( &_this->Indicator2, -2000 );
  CoreRectView__OnSetBounds( &_this->TextX, _Const000C );
  ViewsText_OnSetAlignment( &_this->TextX, ViewsTextAlignmentAlignHorzRight | ViewsTextAlignmentAlignVertCenter );
  ViewsText_OnSetString( &_this->TextX, EwLoadString( &_Const000D ));
  CoreRectView__OnSetBounds( &_this->TextY, _Const000E );
  ViewsText_OnSetAlignment( &_this->TextY, ViewsTextAlignmentAlignHorzRight | ViewsTextAlignmentAlignVertCenter );
  ViewsText_OnSetString( &_this->TextY, EwLoadString( &_Const000D ));
  CoreRectView__OnSetBounds( &_this->TextZ, _Const000F );
  ViewsText_OnSetAlignment( &_this->TextZ, ViewsTextAlignmentAlignHorzRight | ViewsTextAlignmentAlignVertCenter );
  ViewsText_OnSetString( &_this->TextZ, EwLoadString( &_Const000D ));
  CoreTimer_OnSetEnabled( &_this->PerformanceTimer, 1 );
  CoreRectView__OnSetBounds( &_this->FpsDescr, _Const0010 );
  ViewsText_OnSetAlignment( &_this->FpsDescr, ViewsTextAlignmentAlignHorzRight | 
  ViewsTextAlignmentAlignVertCenter );
  ViewsText_OnSetString( &_this->FpsDescr, EwLoadString( &_Const0011 ));
  CoreRectView__OnSetBounds( &_this->FpsText, _Const0012 );
  ViewsText_OnSetAlignment( &_this->FpsText, ViewsTextAlignmentAlignHorzRight | 
  ViewsTextAlignmentAlignVertCenter );
  ViewsText_OnSetString( &_this->FpsText, EwLoadString( &_Const0013 ));
  CoreRectView__OnSetBounds( &_this->SlideTouchHandler, _Const0000 );
  CoreSlideTouchHandler_OnSetSnapNext( &_this->SlideTouchHandler, _Const0014 );
  _this->SlideTouchHandler.SlideHorz = 0;
  CoreRectView__OnSetBounds( &_this->Outline, _Const0015 );
  CoreOutline_OnSetSpaceVert( &_this->Outline, 0 );
  CoreRectView__OnSetBounds( &_this->DataGraphX, _Const0016 );
  CoreGroup_OnSetEmbedded((CoreGroup)&_this->DataGraphX, 1 );
  ApplicationDataGraph_OnSetGraphColor( &_this->DataGraphX, _Const0017 );
  CoreRectView__OnSetBounds( &_this->DataGraphY, _Const0018 );
  CoreGroup_OnSetEmbedded((CoreGroup)&_this->DataGraphY, 1 );
  ApplicationDataGraph_OnSetGraphColor( &_this->DataGraphY, _Const0019 );
  CoreRectView__OnSetBounds( &_this->DataGraphZ, _Const001A );
  CoreGroup_OnSetEmbedded((CoreGroup)&_this->DataGraphZ, 1 );
  ApplicationDataGraph_OnSetGraphColor( &_this->DataGraphZ, _Const001B );
  CoreRectView__OnSetBounds( &_this->Oscilloscope, _Const001C );
  CoreGroup_OnSetEmbedded((CoreGroup)&_this->Oscilloscope, 1 );
  ApplicationOscilloscope_OnSetBallColor( &_this->Oscilloscope, _Const001D );
  CoreRectView__OnSetBounds( &_this->Image, _Const001E );
  ViewsImage_OnSetEmbedded( &_this->Image, 1 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Background ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->CaptionText ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->TextDescriptionMcoXValue ), 
  0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->TextDescriptionMcoYValue ), 
  0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->TextDescriptionMcoZValue ), 
  0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Indicator ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Indicator1 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Indicator2 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->TextX ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->TextY ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->TextZ ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->FpsDescr ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->FpsText ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->SlideTouchHandler ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Outline ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->DataGraphX ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->DataGraphY ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->DataGraphZ ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Oscilloscope ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Image ), 0 );
  ViewsImage_OnSetBitmap( &_this->Background, EwLoadResource( &ApplicationBackground, 
  ResourcesBitmap ));
  ViewsText_OnSetFont( &_this->CaptionText, EwLoadResource( &ResourcesFontMedium, 
  ResourcesFont ));
  _this->Device = EwGetAutoObject( &ApplicationDevice, ApplicationDeviceClass );
  ViewsText_OnSetFont( &_this->TextDescriptionMcoXValue, EwLoadResource( &ResourcesFontLarge, 
  ResourcesFont ));
  ViewsText_OnSetFont( &_this->TextDescriptionMcoYValue, EwLoadResource( &ResourcesFontLarge, 
  ResourcesFont ));
  ViewsText_OnSetFont( &_this->TextDescriptionMcoZValue, EwLoadResource( &ResourcesFontLarge, 
  ResourcesFont ));
  _this->McoXValueObserver.OnEvent = EwNewSlot( _this, ApplicationApplication_onMcoXValueEvent );
  CorePropertyObserver_OnSetOutlet( &_this->McoXValueObserver, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoXValue, 
  ApplicationDeviceClass_OnSetMcoXValue ));
  _this->McoYValueObserver.OnEvent = EwNewSlot( _this, ApplicationApplication_onMcoYValueEvent );
  CorePropertyObserver_OnSetOutlet( &_this->McoYValueObserver, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoYValue, 
  ApplicationDeviceClass_OnSetMcoYValue ));
  _this->McoZValueObserver.OnEvent = EwNewSlot( _this, ApplicationApplication_onMcoZValueEvent );
  CorePropertyObserver_OnSetOutlet( &_this->McoZValueObserver, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoZValue, 
  ApplicationDeviceClass_OnSetMcoZValue ));
  ApplicationIndicator_OnSetOutlet( &_this->Indicator, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoXValue, 
  ApplicationDeviceClass_OnSetMcoXValue ));
  ApplicationIndicator_OnSetOutlet( &_this->Indicator1, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoYValue, 
  ApplicationDeviceClass_OnSetMcoYValue ));
  ApplicationIndicator_OnSetOutlet( &_this->Indicator2, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoZValue, 
  ApplicationDeviceClass_OnSetMcoZValue ));
  ViewsText_OnSetFont( &_this->TextX, EwLoadResource( &ResourcesFontLarge, ResourcesFont ));
  ViewsText_OnSetFont( &_this->TextY, EwLoadResource( &ResourcesFontLarge, ResourcesFont ));
  ViewsText_OnSetFont( &_this->TextZ, EwLoadResource( &ResourcesFontLarge, ResourcesFont ));
  _this->PerformanceTimer.OnTrigger = EwNewSlot( _this, ApplicationApplication_PerformanceSlot );
  ViewsText_OnSetFont( &_this->FpsDescr, EwLoadResource( &ResourcesFontSmall, ResourcesFont ));
  ViewsText_OnSetFont( &_this->FpsText, EwLoadResource( &ResourcesFontSmall, ResourcesFont ));
  CoreOutline_OnSetSlideHandler( &_this->Outline, &_this->SlideTouchHandler );
  ApplicationDataGraph_OnSetOutletData( &_this->DataGraphX, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoXValue, 
  ApplicationDeviceClass_OnSetMcoXValue ));
  ApplicationDataGraph_OnSetOutletData( &_this->DataGraphY, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoYValue, 
  ApplicationDeviceClass_OnSetMcoYValue ));
  ApplicationDataGraph_OnSetOutletData( &_this->DataGraphZ, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoZValue, 
  ApplicationDeviceClass_OnSetMcoZValue ));
  ApplicationOscilloscope_OnSetOutletXData( &_this->Oscilloscope, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoXValue, 
  ApplicationDeviceClass_OnSetMcoXValue ));
  ApplicationOscilloscope_OnSetOutletYData( &_this->Oscilloscope, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoYValue, 
  ApplicationDeviceClass_OnSetMcoYValue ));
  ApplicationOscilloscope_OnSetOutletZData( &_this->Oscilloscope, EwNewRef( EwGetAutoObject( 
  &ApplicationDevice, ApplicationDeviceClass ), ApplicationDeviceClass_OnGetMcoZValue, 
  ApplicationDeviceClass_OnSetMcoZValue ));
  ViewsImage_OnSetBitmap( &_this->Image, EwLoadResource( &ApplicationAbout, ResourcesBitmap ));
}

/* Re-Initializer for the class 'Application::Application' */
void ApplicationApplication__ReInit( ApplicationApplication _this )
{
  /* At first re-initialize the super class ... */
  CoreRoot__ReInit( &_this->_Super );

  /* ... then re-construct all embedded objects */
  ViewsImage__ReInit( &_this->Background );
  ViewsText__ReInit( &_this->CaptionText );
  ViewsText__ReInit( &_this->TextDescriptionMcoXValue );
  ViewsText__ReInit( &_this->TextDescriptionMcoYValue );
  ViewsText__ReInit( &_this->TextDescriptionMcoZValue );
  CorePropertyObserver__ReInit( &_this->McoXValueObserver );
  CorePropertyObserver__ReInit( &_this->McoYValueObserver );
  CorePropertyObserver__ReInit( &_this->McoZValueObserver );
  ApplicationIndicator__ReInit( &_this->Indicator );
  ApplicationIndicator__ReInit( &_this->Indicator1 );
  ApplicationIndicator__ReInit( &_this->Indicator2 );
  ViewsText__ReInit( &_this->TextX );
  ViewsText__ReInit( &_this->TextY );
  ViewsText__ReInit( &_this->TextZ );
  CoreTimer__ReInit( &_this->PerformanceTimer );
  ViewsText__ReInit( &_this->FpsDescr );
  ViewsText__ReInit( &_this->FpsText );
  CoreSlideTouchHandler__ReInit( &_this->SlideTouchHandler );
  CoreOutline__ReInit( &_this->Outline );
  ApplicationDataGraph__ReInit( &_this->DataGraphX );
  ApplicationDataGraph__ReInit( &_this->DataGraphY );
  ApplicationDataGraph__ReInit( &_this->DataGraphZ );
  ApplicationOscilloscope__ReInit( &_this->Oscilloscope );
  ViewsImage__ReInit( &_this->Image );
}

/* Finalizer method for the class 'Application::Application' */
void ApplicationApplication__Done( ApplicationApplication _this )
{
  /* Finalize this class */
  _this->_Super._VMT = EW_CLASS( CoreRoot );

  /* Finalize all embedded objects */
  ViewsImage__Done( &_this->Background );
  ViewsText__Done( &_this->CaptionText );
  ViewsText__Done( &_this->TextDescriptionMcoXValue );
  ViewsText__Done( &_this->TextDescriptionMcoYValue );
  ViewsText__Done( &_this->TextDescriptionMcoZValue );
  CorePropertyObserver__Done( &_this->McoXValueObserver );
  CorePropertyObserver__Done( &_this->McoYValueObserver );
  CorePropertyObserver__Done( &_this->McoZValueObserver );
  ApplicationIndicator__Done( &_this->Indicator );
  ApplicationIndicator__Done( &_this->Indicator1 );
  ApplicationIndicator__Done( &_this->Indicator2 );
  ViewsText__Done( &_this->TextX );
  ViewsText__Done( &_this->TextY );
  ViewsText__Done( &_this->TextZ );
  CoreTimer__Done( &_this->PerformanceTimer );
  ViewsText__Done( &_this->FpsDescr );
  ViewsText__Done( &_this->FpsText );
  CoreSlideTouchHandler__Done( &_this->SlideTouchHandler );
  CoreOutline__Done( &_this->Outline );
  ApplicationDataGraph__Done( &_this->DataGraphX );
  ApplicationDataGraph__Done( &_this->DataGraphY );
  ApplicationDataGraph__Done( &_this->DataGraphZ );
  ApplicationOscilloscope__Done( &_this->Oscilloscope );
  ViewsImage__Done( &_this->Image );

  /* Don't forget to deinitialize the super class ... */
  CoreRoot__Done( &_this->_Super );
}

/* This slot method is executed when the associated property observer is notified. */
void ApplicationApplication_onMcoXValueEvent( ApplicationApplication _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  ViewsText_OnSetString( &_this->TextX, EwNewStringInt( EwGetAutoObject( &ApplicationDevice, 
  ApplicationDeviceClass )->McoXValue, 0, 10 ));
}

/* This slot method is executed when the associated property observer is notified. */
void ApplicationApplication_onMcoYValueEvent( ApplicationApplication _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  ViewsText_OnSetString( &_this->TextY, EwNewStringInt( EwGetAutoObject( &ApplicationDevice, 
  ApplicationDeviceClass )->McoYValue, 0, 10 ));
}

/* This slot method is executed when the associated property observer is notified. */
void ApplicationApplication_onMcoZValueEvent( ApplicationApplication _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  ViewsText_OnSetString( &_this->TextZ, EwNewStringInt( EwGetAutoObject( &ApplicationDevice, 
  ApplicationDeviceClass )->McoZValue, 0, 10 ));
}

/* 'C' function for method : 'Application::Application.PerformanceSlot()' */
void ApplicationApplication_PerformanceSlot( ApplicationApplication _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  if ( CoreView__GetRoot( _this ) != 0 )
    ViewsText_OnSetString( &_this->FpsText, EwConcatString( EwNewStringInt( CoreRoot_GetFPS( 
    CoreView__GetRoot( _this )), 0, 10 ), EwLoadString( &_Const001F )));
}

/* Variants derived from the class : 'Application::Application' */
EW_DEFINE_CLASS_VARIANTS( ApplicationApplication )
EW_END_OF_CLASS_VARIANTS( ApplicationApplication )

/* Virtual Method Table (VMT) for the class : 'Application::Application' */
EW_DEFINE_CLASS( ApplicationApplication, CoreRoot, Device, Background, Background, 
                 Background, _None, _None, "Application::Application" )
  CoreRectView_initLayoutContext,
  CoreRoot_GetRoot,
  CoreRoot_Draw,
  CoreView_HandleEvent,
  CoreGroup_CursorHitTest,
  CoreRectView_ArrangeView,
  CoreRectView_MoveView,
  CoreRectView_GetExtent,
  CoreRoot_ChangeViewState,
  CoreGroup_OnSetBounds,
  CoreRoot_OnSetFocus,
  CoreRoot_DispatchEvent,
  CoreRoot_BroadcastEvent,
  CoreGroup_UpdateLayout,
  CoreGroup_UpdateViewState,
  CoreRoot_InvalidateArea,
EW_END_OF_CLASS( ApplicationApplication )

/* Initializer for the class 'Application::DeviceClass' */
void ApplicationDeviceClass__Init( ApplicationDeviceClass _this, XObject aLink, XHandle aArg )
{
  /* At first initialize the super class ... */
  XObject__Init( &_this->_Super, aLink, aArg );

  /* Allow the Immediate Garbage Collection to evalute the members of this class. */
  _this->_GCT = EW_CLASS_GCT( ApplicationDeviceClass );

  /* ... then construct all embedded objects */
  EffectsInt32Effect__Init( &_this->XEffect, &_this->_XObject, 0 );
  EffectsInt32Effect__Init( &_this->YEffect, &_this->_XObject, 0 );
  EffectsInt32Effect__Init( &_this->ZEffect, &_this->_XObject, 0 );

  /* Setup the VMT pointer */
  _this->_VMT = EW_CLASS( ApplicationDeviceClass );

  /* ... and initialize objects, variables, properties, etc. */
  _this->XEffect.Super1.Symmetric = 1;
  EffectsEffect_OnSetTiming((EffectsEffect)&_this->XEffect, EffectsTimingEaseIn_EaseOut );
  EffectsEffect_OnSetInitialDelay((EffectsEffect)&_this->XEffect, 400 );
  EffectsEffect_OnSetEnabled((EffectsEffect)&_this->XEffect, 1 );
  _this->XEffect.Value2 = 2500;
  _this->XEffect.Value1 = -2500;
  _this->YEffect.Super1.Symmetric = 1;
  EffectsEffect_OnSetTiming((EffectsEffect)&_this->YEffect, EffectsTimingEaseIn_EaseOut );
  EffectsEffect_OnSetCycleDuration((EffectsEffect)&_this->YEffect, 1200 );
  EffectsEffect_OnSetInitialDelay((EffectsEffect)&_this->YEffect, 500 );
  EffectsEffect_OnSetEnabled((EffectsEffect)&_this->YEffect, 1 );
  _this->YEffect.Value2 = 2500;
  _this->YEffect.Value1 = -2500;
  _this->ZEffect.Super1.Symmetric = 1;
  EffectsEffect_OnSetTiming((EffectsEffect)&_this->ZEffect, EffectsTimingEaseIn_EaseOut );
  EffectsEffect_OnSetCycleDuration((EffectsEffect)&_this->ZEffect, 1500 );
  EffectsEffect_OnSetInitialDelay((EffectsEffect)&_this->ZEffect, 600 );
  EffectsEffect_OnSetEnabled((EffectsEffect)&_this->ZEffect, 1 );
  _this->ZEffect.Value2 = 2500;
  _this->ZEffect.Value1 = -2500;
  _this->XEffect.Super1.OnAnimate = EwNewSlot( _this, ApplicationDeviceClass_XSlot );
  _this->YEffect.Super1.OnAnimate = EwNewSlot( _this, ApplicationDeviceClass_YSlot );
  _this->ZEffect.Super1.OnAnimate = EwNewSlot( _this, ApplicationDeviceClass_ZSlot );
}

/* Re-Initializer for the class 'Application::DeviceClass' */
void ApplicationDeviceClass__ReInit( ApplicationDeviceClass _this )
{
  /* At first re-initialize the super class ... */
  XObject__ReInit( &_this->_Super );

  /* ... then re-construct all embedded objects */
  EffectsInt32Effect__ReInit( &_this->XEffect );
  EffectsInt32Effect__ReInit( &_this->YEffect );
  EffectsInt32Effect__ReInit( &_this->ZEffect );
}

/* Finalizer method for the class 'Application::DeviceClass' */
void ApplicationDeviceClass__Done( ApplicationDeviceClass _this )
{
  /* Finalize this class */
  _this->_Super._VMT = EW_CLASS( XObject );

  /* Finalize all embedded objects */
  EffectsInt32Effect__Done( &_this->XEffect );
  EffectsInt32Effect__Done( &_this->YEffect );
  EffectsInt32Effect__Done( &_this->ZEffect );

  /* Don't forget to deinitialize the super class ... */
  XObject__Done( &_this->_Super );
}

/* This method is intended to be called by the device driver to notify the GUI application 
   about an alternation of its setting or state value. */
void ApplicationDeviceClass_UpdateMcoCounter( ApplicationDeviceClass _this, XInt32 
  aNewValue )
{
  if ( aNewValue != _this->McoCounter )
  {
    _this->McoCounter = aNewValue;
    EwNotifyRefObservers( EwNewRef( _this, ApplicationDeviceClass_OnGetMcoCounter, 
      ApplicationDeviceClass_OnSetMcoCounter ), 0 );
    EffectsEffect_OnSetEnabled((EffectsEffect)&_this->XEffect, 0 );
    EffectsEffect_OnSetEnabled((EffectsEffect)&_this->YEffect, 0 );
    EffectsEffect_OnSetEnabled((EffectsEffect)&_this->ZEffect, 0 );
  }
}

/* Wrapper function for the non virtual method : 'Application::DeviceClass.UpdateMcoCounter()' */
void ApplicationDeviceClass__UpdateMcoCounter( void* _this, XInt32 aNewValue )
{
  ApplicationDeviceClass_UpdateMcoCounter((ApplicationDeviceClass)_this, aNewValue );
}

/* This method is intended to be called by the device driver to notify the GUI application 
   about an alternation of its setting or state value. */
void ApplicationDeviceClass_UpdateMcoXValue( ApplicationDeviceClass _this, XInt32 
  aNewValue )
{
  _this->McoXValue = aNewValue;
  EwNotifyRefObservers( EwNewRef( _this, ApplicationDeviceClass_OnGetMcoXValue, 
    ApplicationDeviceClass_OnSetMcoXValue ), 0 );
}

/* Wrapper function for the non virtual method : 'Application::DeviceClass.UpdateMcoXValue()' */
void ApplicationDeviceClass__UpdateMcoXValue( void* _this, XInt32 aNewValue )
{
  ApplicationDeviceClass_UpdateMcoXValue((ApplicationDeviceClass)_this, aNewValue );
}

/* This method is intended to be called by the device driver to notify the GUI application 
   about an alternation of its setting or state value. */
void ApplicationDeviceClass_UpdateMcoYValue( ApplicationDeviceClass _this, XInt32 
  aNewValue )
{
  _this->McoYValue = aNewValue;
  EwNotifyRefObservers( EwNewRef( _this, ApplicationDeviceClass_OnGetMcoYValue, 
    ApplicationDeviceClass_OnSetMcoYValue ), 0 );
}

/* Wrapper function for the non virtual method : 'Application::DeviceClass.UpdateMcoYValue()' */
void ApplicationDeviceClass__UpdateMcoYValue( void* _this, XInt32 aNewValue )
{
  ApplicationDeviceClass_UpdateMcoYValue((ApplicationDeviceClass)_this, aNewValue );
}

/* This method is intended to be called by the device driver to notify the GUI application 
   about an alternation of its setting or state value. */
void ApplicationDeviceClass_UpdateMcoZValue( ApplicationDeviceClass _this, XInt32 
  aNewValue )
{
  _this->McoZValue = aNewValue;
  EwNotifyRefObservers( EwNewRef( _this, ApplicationDeviceClass_OnGetMcoZValue, 
    ApplicationDeviceClass_OnSetMcoZValue ), 0 );
}

/* Wrapper function for the non virtual method : 'Application::DeviceClass.UpdateMcoZValue()' */
void ApplicationDeviceClass__UpdateMcoZValue( void* _this, XInt32 aNewValue )
{
  ApplicationDeviceClass_UpdateMcoZValue((ApplicationDeviceClass)_this, aNewValue );
}

/* 'C' function for method : 'Application::DeviceClass.XSlot()' */
void ApplicationDeviceClass_XSlot( ApplicationDeviceClass _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  ApplicationDeviceClass_UpdateMcoXValue( _this, _this->XEffect.Value );
}

/* 'C' function for method : 'Application::DeviceClass.YSlot()' */
void ApplicationDeviceClass_YSlot( ApplicationDeviceClass _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  ApplicationDeviceClass_UpdateMcoYValue( _this, _this->YEffect.Value );
}

/* 'C' function for method : 'Application::DeviceClass.ZSlot()' */
void ApplicationDeviceClass_ZSlot( ApplicationDeviceClass _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  ApplicationDeviceClass_UpdateMcoZValue( _this, _this->ZEffect.Value );
}

/* Default onget method for the property 'McoCounter' */
XInt32 ApplicationDeviceClass_OnGetMcoCounter( ApplicationDeviceClass _this )
{
  return _this->McoCounter;
}

/* Default onset method for the property 'McoCounter' */
void ApplicationDeviceClass_OnSetMcoCounter( ApplicationDeviceClass _this, XInt32 
  value )
{
  _this->McoCounter = value;
}

/* Default onget method for the property 'McoXValue' */
XInt32 ApplicationDeviceClass_OnGetMcoXValue( ApplicationDeviceClass _this )
{
  return _this->McoXValue;
}

/* Default onset method for the property 'McoXValue' */
void ApplicationDeviceClass_OnSetMcoXValue( ApplicationDeviceClass _this, XInt32 
  value )
{
  _this->McoXValue = value;
}

/* Default onget method for the property 'McoYValue' */
XInt32 ApplicationDeviceClass_OnGetMcoYValue( ApplicationDeviceClass _this )
{
  return _this->McoYValue;
}

/* Default onset method for the property 'McoYValue' */
void ApplicationDeviceClass_OnSetMcoYValue( ApplicationDeviceClass _this, XInt32 
  value )
{
  _this->McoYValue = value;
}

/* Default onget method for the property 'McoZValue' */
XInt32 ApplicationDeviceClass_OnGetMcoZValue( ApplicationDeviceClass _this )
{
  return _this->McoZValue;
}

/* Default onset method for the property 'McoZValue' */
void ApplicationDeviceClass_OnSetMcoZValue( ApplicationDeviceClass _this, XInt32 
  value )
{
  _this->McoZValue = value;
}

/* Variants derived from the class : 'Application::DeviceClass' */
EW_DEFINE_CLASS_VARIANTS( ApplicationDeviceClass )
EW_END_OF_CLASS_VARIANTS( ApplicationDeviceClass )

/* Virtual Method Table (VMT) for the class : 'Application::DeviceClass' */
EW_DEFINE_CLASS( ApplicationDeviceClass, XObject, XEffect, XEffect, XEffect, XEffect, 
                 McoCounter, McoCounter, "Application::DeviceClass" )
EW_END_OF_CLASS( ApplicationDeviceClass )

/* This object represents an instance of the device interface implemented in the 
   class Application::DeviceClass. */
EW_DEFINE_AUTOOBJECT( ApplicationDevice, ApplicationDeviceClass )

/* Initializer for the auto object 'Application::Device' */
void ApplicationDevice__Init( ApplicationDeviceClass _this )
{
  EW_UNUSED_ARG( _this );
}

/* Table with links to derived variants of the auto object : 'Application::Device' */
EW_DEFINE_AUTOOBJECT_VARIANTS( ApplicationDevice )
EW_END_OF_AUTOOBJECT_VARIANTS( ApplicationDevice )

/* Include a file containing the bitmap resource : 'Application::Ball' */
#include "_ApplicationBall.h"

/* Table with links to derived variants of the bitmap resource : 'Application::Ball' */
EW_RES_WITHOUT_VARIANTS( ApplicationBall )

/* Initializer for the class 'Application::Oscilloscope' */
void ApplicationOscilloscope__Init( ApplicationOscilloscope _this, XObject aLink, XHandle aArg )
{
  /* At first initialize the super class ... */
  CoreGroup__Init( &_this->_Super, aLink, aArg );

  /* Allow the Immediate Garbage Collection to evalute the members of this class. */
  _this->_GCT = EW_CLASS_GCT( ApplicationOscilloscope );

  /* ... then construct all embedded objects */
  ViewsImage__Init( &_this->Background, &_this->_XObject, 0 );
  ViewsWarpImage__Init( &_this->Ball, &_this->_XObject, 0 );

  /* Setup the VMT pointer */
  _this->_VMT = EW_CLASS( ApplicationOscilloscope );

  /* ... and initialize objects, variables, properties, etc. */
  CoreRectView__OnSetBounds( _this, _Const0020 );
  _this->BallColor = _Const0021;
  CoreRectView__OnSetBounds( &_this->Background, _Const0020 );
  CoreQuadView__OnSetPoint4( &_this->Ball, _Const0022 );
  CoreQuadView__OnSetPoint3( &_this->Ball, _Const0023 );
  CoreQuadView__OnSetPoint2( &_this->Ball, _Const0024 );
  CoreQuadView__OnSetPoint1( &_this->Ball, _Const0025 );
  ViewsWarpView_OnSetSourceAnchor((ViewsWarpView)&_this->Ball, _Const0026 );
  ViewsWarpImage_OnSetColor( &_this->Ball, _Const0027 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Background ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Ball ), 0 );
  ViewsImage_OnSetBitmap( &_this->Background, EwLoadResource( &ApplicationGridLarge, 
  ResourcesBitmap ));
  ViewsWarpImage_OnSetBitmap( &_this->Ball, EwLoadResource( &ApplicationBall, ResourcesBitmap ));
}

/* Re-Initializer for the class 'Application::Oscilloscope' */
void ApplicationOscilloscope__ReInit( ApplicationOscilloscope _this )
{
  /* At first re-initialize the super class ... */
  CoreGroup__ReInit( &_this->_Super );

  /* ... then re-construct all embedded objects */
  ViewsImage__ReInit( &_this->Background );
  ViewsWarpImage__ReInit( &_this->Ball );
}

/* Finalizer method for the class 'Application::Oscilloscope' */
void ApplicationOscilloscope__Done( ApplicationOscilloscope _this )
{
  /* Finalize this class */
  _this->_Super._VMT = EW_CLASS( CoreGroup );

  /* Finalize all embedded objects */
  ViewsImage__Done( &_this->Background );
  ViewsWarpImage__Done( &_this->Ball );

  /* Don't forget to deinitialize the super class ... */
  CoreGroup__Done( &_this->_Super );
}

/* The method UpdateViewState() is invoked automatically after the state of the 
   component has been changed. This method can be overridden and filled with logic 
   to ensure the visual aspect of the component does reflect its current state. 
   For example, the 'enabled' state of the component can affect its colors (disabled 
   components may appear pale). In this case the logic of the method should modify 
   the respective color properties accordingly to the current 'enabled' state. 
   The current state of the component is passed as a set in the parameter aState. 
   It reflects the very basic component state like its visibility or the ability 
   to react to user inputs. Beside this common state, the method can also involve 
   any other variables used in the component as long as they reflect its current 
   state. For example, the toggle switch component can take in account its toggle 
   state 'on' or 'off' and change accordingly the location of the slider, etc.
   Usually, this method will be invoked automatically by the framework. Optionally 
   you can request its invocation by using the method @InvalidateViewState(). */
void ApplicationOscilloscope_UpdateViewState( ApplicationOscilloscope _this, XSet 
  aState )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( aState );

  EwPostSignal( EwNewSlot( _this, ApplicationOscilloscope_UpdateBall ), ((XObject)_this ));
}

/* The onset method for the property 'BeamColor' changes the color of the simulated 
   beam. */
void ApplicationOscilloscope_OnSetBallColor( ApplicationOscilloscope _this, XColor 
  value )
{
  if ( !EwCompColor( _this->BallColor, value ))
    return;

  _this->BallColor = value;
  ViewsWarpImage_OnSetColor( &_this->Ball, value );
}

/* 'C' function for method : 'Application::Oscilloscope.UpdateBall()' */
void ApplicationOscilloscope_UpdateBall( ApplicationOscilloscope _this, XObject 
  sender )
{
  XInt32 w;
  XInt32 h;
  XInt32 x;
  XInt32 y;
  XFloat scale;

  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  w = EwGetRectW( _this->Super2.Bounds ) / 2;
  h = EwGetRectH( _this->Super2.Bounds ) / 2;
  x = w + (( w * EwGetAutoObject( &ApplicationDevice, ApplicationDeviceClass )->McoXValue ) 
  / 3000 );
  y = h + (( h * EwGetAutoObject( &ApplicationDevice, ApplicationDeviceClass )->McoYValue ) 
  / 3000 );
  scale = (XFloat)( EwGetAutoObject( &ApplicationDevice, ApplicationDeviceClass )->McoZValue 
  + 3000 ) / 5000.000000f;
  ViewsWarpView_RotateAndScale((ViewsWarpView)&_this->Ball, EwNewPoint( x, y ), 
  0.000000f, scale, scale );
}

/* 'C' function for method : 'Application::Oscilloscope.OnSetOutletXData()' */
void ApplicationOscilloscope_OnSetOutletXData( ApplicationOscilloscope _this, XRef 
  value )
{
  if ( !EwCompRef( _this->OutletXData, value ))
    return;

  if ( _this->OutletXData.Object != 0 )
    EwDetachRefObserver( EwNewSlot( _this, ApplicationOscilloscope_outletDataSlot ), 
      _this->OutletXData, 0 );

  _this->OutletXData = value;

  if ( value.Object != 0 )
    EwAttachRefObserver( EwNewSlot( _this, ApplicationOscilloscope_outletDataSlot ), 
      value, 0 );

  if ( value.Object != 0 )
    EwPostSignal( EwNewSlot( _this, ApplicationOscilloscope_outletDataSlot ), ((XObject)_this ));
}

/* 'C' function for method : 'Application::Oscilloscope.OnSetOutletYData()' */
void ApplicationOscilloscope_OnSetOutletYData( ApplicationOscilloscope _this, XRef 
  value )
{
  if ( !EwCompRef( _this->OutletYData, value ))
    return;

  if ( _this->OutletYData.Object != 0 )
    EwDetachRefObserver( EwNewSlot( _this, ApplicationOscilloscope_outletDataSlot ), 
      _this->OutletYData, 0 );

  _this->OutletYData = value;

  if ( value.Object != 0 )
    EwAttachRefObserver( EwNewSlot( _this, ApplicationOscilloscope_outletDataSlot ), 
      value, 0 );

  if ( value.Object != 0 )
    EwPostSignal( EwNewSlot( _this, ApplicationOscilloscope_outletDataSlot ), ((XObject)_this ));
}

/* This slot method will receive a signal, if the value of the property assigned 
   to @Outlet has been changed by another widget or by the application logic. In 
   response to this notification, the widget will update itself. */
void ApplicationOscilloscope_outletDataSlot( ApplicationOscilloscope _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  EwPostSignal( EwNewSlot( _this, ApplicationOscilloscope_UpdateBall ), ((XObject)_this ));
}

/* 'C' function for method : 'Application::Oscilloscope.OnSetOutletZData()' */
void ApplicationOscilloscope_OnSetOutletZData( ApplicationOscilloscope _this, XRef 
  value )
{
  if ( !EwCompRef( _this->OutletZData, value ))
    return;

  if ( _this->OutletZData.Object != 0 )
    EwDetachRefObserver( EwNewSlot( _this, ApplicationOscilloscope_outletDataSlot ), 
      _this->OutletZData, 0 );

  _this->OutletZData = value;

  if ( value.Object != 0 )
    EwAttachRefObserver( EwNewSlot( _this, ApplicationOscilloscope_outletDataSlot ), 
      value, 0 );

  if ( value.Object != 0 )
    EwPostSignal( EwNewSlot( _this, ApplicationOscilloscope_outletDataSlot ), ((XObject)_this ));
}

/* Variants derived from the class : 'Application::Oscilloscope' */
EW_DEFINE_CLASS_VARIANTS( ApplicationOscilloscope )
EW_END_OF_CLASS_VARIANTS( ApplicationOscilloscope )

/* Virtual Method Table (VMT) for the class : 'Application::Oscilloscope' */
EW_DEFINE_CLASS( ApplicationOscilloscope, CoreGroup, OutletXData, OutletXData, OutletXData, 
                 Background, BallColor, BallColor, "Application::Oscilloscope" )
  CoreRectView_initLayoutContext,
  CoreView_GetRoot,
  CoreGroup_Draw,
  CoreView_HandleEvent,
  CoreGroup_CursorHitTest,
  CoreRectView_ArrangeView,
  CoreRectView_MoveView,
  CoreRectView_GetExtent,
  CoreGroup_ChangeViewState,
  CoreGroup_OnSetBounds,
  CoreGroup_OnSetFocus,
  CoreGroup_DispatchEvent,
  CoreGroup_BroadcastEvent,
  CoreGroup_UpdateLayout,
  ApplicationOscilloscope_UpdateViewState,
  CoreGroup_InvalidateArea,
EW_END_OF_CLASS( ApplicationOscilloscope )

/* Include a file containing the bitmap resource : 'Application::Background' */
#include "_ApplicationBackground.h"

/* Table with links to derived variants of the bitmap resource : 'Application::Background' */
EW_RES_WITHOUT_VARIANTS( ApplicationBackground )

/* Initializer for the class 'Application::Indicator' */
void ApplicationIndicator__Init( ApplicationIndicator _this, XObject aLink, XHandle aArg )
{
  /* At first initialize the super class ... */
  CoreGroup__Init( &_this->_Super, aLink, aArg );

  /* Allow the Immediate Garbage Collection to evalute the members of this class. */
  _this->_GCT = EW_CLASS_GCT( ApplicationIndicator );

  /* ... then construct all embedded objects */
  ViewsRectangle__Init( &_this->Background, &_this->_XObject, 0 );
  ViewsRectangle__Init( &_this->Rectangle, &_this->_XObject, 0 );

  /* Setup the VMT pointer */
  _this->_VMT = EW_CLASS( ApplicationIndicator );

  /* ... and initialize objects, variables, properties, etc. */
  CoreRectView__OnSetBounds( _this, _Const0028 );
  _this->CurrentValue = 100;
  CoreView_OnSetLayout((CoreView)&_this->Background, CoreLayoutAlignToBottom | CoreLayoutAlignToLeft 
  | CoreLayoutAlignToRight | CoreLayoutAlignToTop | CoreLayoutResizeHorz | CoreLayoutResizeVert );
  CoreRectView__OnSetBounds( &_this->Background, _Const0029 );
  ViewsRectangle_OnSetColor( &_this->Background, _Const002A );
  CoreRectView__OnSetBounds( &_this->Rectangle, _Const002B );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Background ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Rectangle ), 0 );
}

/* Re-Initializer for the class 'Application::Indicator' */
void ApplicationIndicator__ReInit( ApplicationIndicator _this )
{
  /* At first re-initialize the super class ... */
  CoreGroup__ReInit( &_this->_Super );

  /* ... then re-construct all embedded objects */
  ViewsRectangle__ReInit( &_this->Background );
  ViewsRectangle__ReInit( &_this->Rectangle );
}

/* Finalizer method for the class 'Application::Indicator' */
void ApplicationIndicator__Done( ApplicationIndicator _this )
{
  /* Finalize this class */
  _this->_Super._VMT = EW_CLASS( CoreGroup );

  /* Finalize all embedded objects */
  ViewsRectangle__Done( &_this->Background );
  ViewsRectangle__Done( &_this->Rectangle );

  /* Don't forget to deinitialize the super class ... */
  CoreGroup__Done( &_this->_Super );
}

/* The method UpdateViewState() is invoked automatically after the state of the 
   component has been changed. This method can be overridden and filled with logic 
   to ensure the visual aspect of the component does reflect its current state. 
   For example, the 'enabled' state of the component can affect its colors (disabled 
   components may appear pale). In this case the logic of the method should modify 
   the respective color properties accordingly to the current 'enabled' state. 
   The current state of the component is passed as a set in the parameter aState. 
   It reflects the very basic component state like its visibility or the ability 
   to react to user inputs. Beside this common state, the method can also involve 
   any other variables used in the component as long as they reflect its current 
   state. For example, the toggle switch component can take in account its toggle 
   state 'on' or 'off' and change accordingly the location of the slider, etc.
   Usually, this method will be invoked automatically by the framework. Optionally 
   you can request its invocation by using the method @InvalidateViewState(). */
void ApplicationIndicator_UpdateViewState( ApplicationIndicator _this, XSet aState )
{
  XInt32 x;
  XInt32 w;

  CoreGroup_UpdateViewState((CoreGroup)_this, aState );
  x = EwGetRectW( _this->Super2.Bounds ) / 2;
  w = (( EwGetRectW( _this->Super2.Bounds ) / 2 ) * _this->CurrentValue ) / 3000;

  if ( w < 0 )
    CoreRectView__OnSetBounds( &_this->Rectangle, EwNewRect( x + w, 0, x, EwGetRectH( 
    _this->Super2.Bounds )));
  else
    CoreRectView__OnSetBounds( &_this->Rectangle, EwNewRect( x, 0, x + w, EwGetRectH( 
    _this->Super2.Bounds )));
}

/* The onset method of the property 'Value' changes the currently displayed value 
   of all digits. */
void ApplicationIndicator_OnSetCurrentValue( ApplicationIndicator _this, XInt32 
  value )
{
  if ( _this->CurrentValue == value )
    return;

  _this->CurrentValue = value;
  CoreGroup_InvalidateViewState((CoreGroup)_this );
}

/* This slot method will receive a signal, if the value of the property assigned 
   to @Outlet has been changed by another widget or by the application logic. In 
   response to this notification, the widget will update itself. */
void ApplicationIndicator_outletSlot( ApplicationIndicator _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  if ( _this->Outlet.Object != 0 )
    ApplicationIndicator_OnSetCurrentValue( _this, EwOnGetInt32( _this->Outlet ));
}

/* 'C' function for method : 'Application::Indicator.OnSetOutlet()' */
void ApplicationIndicator_OnSetOutlet( ApplicationIndicator _this, XRef value )
{
  if ( !EwCompRef( _this->Outlet, value ))
    return;

  if ( _this->Outlet.Object != 0 )
    EwDetachRefObserver( EwNewSlot( _this, ApplicationIndicator_outletSlot ), _this->Outlet, 
      0 );

  _this->Outlet = value;

  if ( value.Object != 0 )
    EwAttachRefObserver( EwNewSlot( _this, ApplicationIndicator_outletSlot ), value, 
      0 );

  if ( value.Object != 0 )
    EwPostSignal( EwNewSlot( _this, ApplicationIndicator_outletSlot ), ((XObject)_this ));
}

/* Variants derived from the class : 'Application::Indicator' */
EW_DEFINE_CLASS_VARIANTS( ApplicationIndicator )
EW_END_OF_CLASS_VARIANTS( ApplicationIndicator )

/* Virtual Method Table (VMT) for the class : 'Application::Indicator' */
EW_DEFINE_CLASS( ApplicationIndicator, CoreGroup, Outlet, Outlet, Outlet, Background, 
                 CurrentValue, CurrentValue, "Application::Indicator" )
  CoreRectView_initLayoutContext,
  CoreView_GetRoot,
  CoreGroup_Draw,
  CoreView_HandleEvent,
  CoreGroup_CursorHitTest,
  CoreRectView_ArrangeView,
  CoreRectView_MoveView,
  CoreRectView_GetExtent,
  CoreGroup_ChangeViewState,
  CoreGroup_OnSetBounds,
  CoreGroup_OnSetFocus,
  CoreGroup_DispatchEvent,
  CoreGroup_BroadcastEvent,
  CoreGroup_UpdateLayout,
  ApplicationIndicator_UpdateViewState,
  CoreGroup_InvalidateArea,
EW_END_OF_CLASS( ApplicationIndicator )

/* Initializer for the class 'Application::DataGraph' */
void ApplicationDataGraph__Init( ApplicationDataGraph _this, XObject aLink, XHandle aArg )
{
  /* At first initialize the super class ... */
  CoreGroup__Init( &_this->_Super, aLink, aArg );

  /* Allow the Immediate Garbage Collection to evalute the members of this class. */
  _this->_GCT = EW_CLASS_GCT( ApplicationDataGraph );

  /* ... then construct all embedded objects */
  ViewsImage__Init( &_this->Image, &_this->_XObject, 0 );
  ViewsStrokePath__Init( &_this->StrokePath, &_this->_XObject, 0 );
  GraphicsPath__Init( &_this->PathData, &_this->_XObject, 0 );

  /* Setup the VMT pointer */
  _this->_VMT = EW_CLASS( ApplicationDataGraph );

  /* ... and initialize objects, variables, properties, etc. */
  CoreRectView__OnSetBounds( _this, _Const002C );
  _this->GraphColor = _Const002D;
  CoreRectView__OnSetBounds( &_this->Image, _Const002C );
  CoreRectView__OnSetBounds( &_this->StrokePath, _Const002E );
  ViewsStrokePath_OnSetColor( &_this->StrokePath, _Const002F );
  ViewsStrokePath_OnSetWidth( &_this->StrokePath, 3.000000f );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Image ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->StrokePath ), 0 );
  ViewsImage_OnSetBitmap( &_this->Image, EwLoadResource( &ApplicationGridSmall, 
  ResourcesBitmap ));
  ViewsStrokePath_OnSetPath( &_this->StrokePath, &_this->PathData );
}

/* Re-Initializer for the class 'Application::DataGraph' */
void ApplicationDataGraph__ReInit( ApplicationDataGraph _this )
{
  /* At first re-initialize the super class ... */
  CoreGroup__ReInit( &_this->_Super );

  /* ... then re-construct all embedded objects */
  ViewsImage__ReInit( &_this->Image );
  ViewsStrokePath__ReInit( &_this->StrokePath );
  GraphicsPath__ReInit( &_this->PathData );
}

/* Finalizer method for the class 'Application::DataGraph' */
void ApplicationDataGraph__Done( ApplicationDataGraph _this )
{
  /* Finalize this class */
  _this->_Super._VMT = EW_CLASS( CoreGroup );

  /* Finalize all embedded objects */
  ViewsImage__Done( &_this->Image );
  ViewsStrokePath__Done( &_this->StrokePath );
  GraphicsPath__Done( &_this->PathData );

  /* Don't forget to deinitialize the super class ... */
  CoreGroup__Done( &_this->_Super );
}

/* The method UpdateLayout() is invoked automatically after the size of the component 
   has been changed. This method can be overridden and filled with logic to perform 
   a sophisticated arrangement calculation for one or more enclosed views. In this 
   case the parameter aSize can be used. It contains the current size of the component. 
   Usually, all enclosed views are arranged automatically accordingly to their @Layout 
   property. UpdateLayout() gives the derived components a chance to extend this 
   automatism by a user defined algorithm. */
void ApplicationDataGraph_UpdateLayout( ApplicationDataGraph _this, XPoint aSize )
{
  GraphicsPath_InitSubPath( &_this->PathData, 0, aSize.X / 2 );
  GraphicsPath_Begin( &_this->PathData, 0, 0.000000f, 0.000000f );
  ViewsStrokePath_OnSetOffset( &_this->StrokePath, EwNewPoint( 0, aSize.Y / 2 ));
  CoreRectView__OnSetBounds( &_this->StrokePath, EwGetRectORect( _this->Super2.Bounds ));
}

/* The onset method for the property 'BeamColor' changes the color of the simulated 
   beam. */
void ApplicationDataGraph_OnSetGraphColor( ApplicationDataGraph _this, XColor value )
{
  if ( !EwCompColor( _this->GraphColor, value ))
    return;

  _this->GraphColor = value;
  ViewsStrokePath_OnSetColor( &_this->StrokePath, value );
}

/* This slot method will receive a signal, if the value of the property assigned 
   to @Outlet has been changed by another widget or by the application logic. In 
   response to this notification, the widget will update itself. */
void ApplicationDataGraph_outletDataSlot( ApplicationDataGraph _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  if ( _this->OutletData.Object != 0 )
    _this->data = EwOnGetInt32( _this->OutletData );

  EwPostSignal( EwNewSlot( _this, ApplicationDataGraph_AddData ), ((XObject)_this ));
}

/* 'C' function for method : 'Application::DataGraph.OnSetOutletData()' */
void ApplicationDataGraph_OnSetOutletData( ApplicationDataGraph _this, XRef value )
{
  if ( !EwCompRef( _this->OutletData, value ))
    return;

  if ( _this->OutletData.Object != 0 )
    EwDetachRefObserver( EwNewSlot( _this, ApplicationDataGraph_outletDataSlot ), 
      _this->OutletData, 0 );

  _this->OutletData = value;

  if ( value.Object != 0 )
    EwAttachRefObserver( EwNewSlot( _this, ApplicationDataGraph_outletDataSlot ), 
      value, 0 );

  if ( value.Object != 0 )
    EwPostSignal( EwNewSlot( _this, ApplicationDataGraph_outletDataSlot ), ((XObject)_this ));
}

/* 'C' function for method : 'Application::DataGraph.AddData()' */
void ApplicationDataGraph_AddData( ApplicationDataGraph _this, XObject sender )
{
  XInt32 h;

  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  h = EwGetRectH( _this->Super2.Bounds ) / 2;

  if ( GraphicsPath_GetNoOfFreeEdges( &_this->PathData, 0 ) == 0 )
    GraphicsPath_ShiftNodes( &_this->PathData, 0, 1, -2.000000f, 0.000000f );
  else
    GraphicsPath_Translate( &_this->PathData, 2.000000f, 0.000000f );

  GraphicsPath_AddLine( &_this->PathData, 0, 0.000000f, (XFloat)(( h * -_this->data ) 
  / 3000 ));
}

/* Variants derived from the class : 'Application::DataGraph' */
EW_DEFINE_CLASS_VARIANTS( ApplicationDataGraph )
EW_END_OF_CLASS_VARIANTS( ApplicationDataGraph )

/* Virtual Method Table (VMT) for the class : 'Application::DataGraph' */
EW_DEFINE_CLASS( ApplicationDataGraph, CoreGroup, OutletData, OutletData, OutletData, 
                 Image, GraphColor, GraphColor, "Application::DataGraph" )
  CoreRectView_initLayoutContext,
  CoreView_GetRoot,
  CoreGroup_Draw,
  CoreView_HandleEvent,
  CoreGroup_CursorHitTest,
  CoreRectView_ArrangeView,
  CoreRectView_MoveView,
  CoreRectView_GetExtent,
  CoreGroup_ChangeViewState,
  CoreGroup_OnSetBounds,
  CoreGroup_OnSetFocus,
  CoreGroup_DispatchEvent,
  CoreGroup_BroadcastEvent,
  ApplicationDataGraph_UpdateLayout,
  CoreGroup_UpdateViewState,
  CoreGroup_InvalidateArea,
EW_END_OF_CLASS( ApplicationDataGraph )

/* Include a file containing the bitmap resource : 'Application::GridSmall' */
#include "_ApplicationGridSmall.h"

/* Table with links to derived variants of the bitmap resource : 'Application::GridSmall' */
EW_RES_WITHOUT_VARIANTS( ApplicationGridSmall )

/* Include a file containing the bitmap resource : 'Application::GridLarge' */
#include "_ApplicationGridLarge.h"

/* Table with links to derived variants of the bitmap resource : 'Application::GridLarge' */
EW_RES_WITHOUT_VARIANTS( ApplicationGridLarge )

/* Include a file containing the bitmap resource : 'Application::About' */
#include "_ApplicationAbout.h"

/* Table with links to derived variants of the bitmap resource : 'Application::About' */
EW_RES_WITHOUT_VARIANTS( ApplicationAbout )

/* Embedded Wizard */
