/**************************************************************************
MODULE:    MCOINST
CONTAINS:  Compatibility with MCO v8+ driver API include
COPYRIGHT: (c) Embedded Systems Academy (EmSA) 2002-2019
           All rights reserved. www.em-sa.com/nxp
DISCLAIM:  Read and understand our disclaimer before using this code!
           www.esacademy.com/disclaim.htm
           This software was written in accordance to the guidelines at
           www.esacademy.com/software/softwarestyleguide.pdf
LICENSE:   THIS IS THE NXP SDK VERSION OF MICROCANOPEN PLUS
           Licensed under a modified BSD License. See LICENSE.INFO
           file in the project root for full license information.
VERSION:   7.00, EmSA 28-JUN-19
           $LastChangedDate: 2019-09-26 12:05:17 +0200 (Thu, 26 Sep 2019) $
           $LastChangedRevision: 4733 $
***************************************************************************/


#ifndef _MCOINST_H
#define _MCOINST_H

#ifdef __cplusplus
extern "C" {
#endif

#include <string.h>
#include "fsl_device_registers.h" // Peripheral Registers
#include "fsl_mcan.h"
#include "pin_mux.h"
#include "fsl_iocon.h"

#include "mcop_inc.h"


#define NUM_CAN_PORTS  1  // This driver supports 1 CAN port

#define CAN_PORT_NUM 0  // Physical CAN port to use (0-1)

#if NUM_CAN_PORTS==1
#if CAN_PORT_NUM==0
#define CAN_LIST_INITIALIZER {CAN0}
#elif CAN_PORT_NUM==1
#define CAN_LIST_INITIALIZER {CAN1}
#endif
#elif NUM_CAN_PORTS==2
#define CAN_LIST_INITIALIZER {CAN0, CAN1}
#endif

#define CAN_PORT_INDEX 0 // The number from the list of initializers to use

#define OPT_SINGLE_HANDLE_PARAM void
#define OPT_FIRST_HANDLE_PARAM 
#define OPT_SINGLE_HANDLE_CALL_PARAM 
#define OPT_FIRST_HANDLE_CALL_PARAM 


#define MCO_PROT_LEGACY    0x01u
#define MCO_PROT_FD        0x02u
#define MCO_PROT_COMANAGER 0x10u

#if defined(MGR_MONITOR_ALL_NODES) && (MGR_MONITOR_ALL_NODES==1)
#define USE_CANOPEN_MANAGER 1
#else
#define USE_CANOPEN_MANAGER 0
#endif

#if defined(USE_CANOPEN_FD) && (USE_CANOPEN_FD==1)
#define PROCESS_CO_FD 1
#else
#define PROCESS_CO_FD 0
#endif
#if !defined(USE_CANOPEN_FD) || (defined(USE_CANOPEN_FD) && (USE_CANOPEN_FD==0))
#define PROCESS_CO_LEGACY 1
#else
#define PROCESS_CO_LEGACY 0
#endif

#define MCO_PROT_BIT_SET(mco_handle,testbits)  ( \
  (testbits==MCO_PROT_LEGACY) ? PROCESS_CO_LEGACY : \
  (testbits==MCO_PROT_FD) ? PROCESS_CO_FD : \
  (testbits==MCO_PROT_COMANAGER) ? USE_CANOPEN_MANAGER : \
  0)


#define HW_STATUS_USED  gMCOConfig.HWStatus

// Empty definition of ´handle´
#define handle (void)0

#endif //  _MCOINST_H
/**************************************************************************
END OF FILE
**************************************************************************/

