/********************************************************************
MODULE:    Cc_user_types.h, target specific user types
CONTAINS:  The user specific global type definitons for CANcrypt
AUTHORS:   Embedded Systems Academy, Inc (USA) and
           Embedded Systems Academy, GmbH (Germany)
HOME:      https://www.cancrypt.net
LICENSE:   See below, APPLIES TO THIS FILE ONLY. 
           See individual file headers for applicable license.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
  implied. See the License for the specific language governing 
  permissions and limitations under the License.

VERSION:   1.03, 06-AUG-2018
           $LastChangedRevision: 466 $
********************************************************************/


#ifndef _CC_USER_TYPES_H
#define _CC_USER_TYPES_H


/********************************************************************
DEFINES: MEMORY TYPE OPTIMIZATION
********************************************************************/
#define MEM_CONST       const
#define MEM_FAR
#define MEM_BUF


/********************************************************************
DEFINES: TRUE AND FALSE
********************************************************************/
#ifndef TRUE
 #define TRUE           (1==1)
#endif
#ifndef FALSE
 #define FALSE          (!TRUE)
#endif


/********************************************************************
TYPEDEF: CANOPEN DATA TYPES
********************************************************************/
typedef unsigned char   UNSIGNED8;
typedef unsigned short  UNSIGNED16;
typedef unsigned int    UNSIGNED32;
typedef unsigned char   uint8_t;
typedef unsigned short  uint16_t;
typedef unsigned int    uint32_t;
typedef char            INTEGER8;
typedef short           INTEGER16;
typedef int             INTEGER32;


/********************************************************************
TYPEDEF: Millisecond timer count (16 or 32bit)
********************************************************************/
#define CC_TIMER_SIZE 16

#if (CC_TIMER_SIZE == 16)

typedef unsigned short  CC_TIMER_TYPE;

#elif (CC_TIMER_SIZE == 32)

typedef unsigned int    CC_TIMER_TYPE;

#endif


/********************************************************************
TYPEDEF: CAN IDENTIFIER TYPE and size
********************************************************************/
#define CAN_ID_SIZE 32

#if (CAN_ID_SIZE == 16)

typedef UNSIGNED16 COBID_TYPE;
#define COBID_DISABLED  0x8000U
#define COBID_RTR       0x4000U
#define COBID_EXT       0x2000U
#define COBID_MASKCTRL  0xE000U
#define COBID_MASKID    0x07FFU

#elif (CAN_ID_SIZE == 32)

typedef UNSIGNED32 COBID_TYPE;
#define COBID_DISABLED  0x80000000UL
#define COBID_RTR       0x40000000UL
#define COBID_EXT       0x20000000UL
#define COBID_MASKCTRL  0xE0000000UL
#define COBID_MASKID    0x1FFFFFFFUL

#else

#error "Only CAN_ID_SIZE 16 or 32 is possible"

#endif


#endif
/*----------------------- END OF FILE -----------------------------*/
