/********************************************************************
MODULE:    Cc_user_config.h, CANcrypt global user configuration
CONTAINS:  Configuration parameters for CANcrypt
AUTHORS:   Embedded Systems Academy, Inc (USA) and
           Embedded Systems Academy, GmbH (Germany)
HOME:      https://www.cancrypt.net
LICENSE:   See below, APPLIES TO THIS FILE ONLY. 
           See individual file headers for applicable license.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
  implied. See the License for the specific language governing 
  permissions and limitations under the License.

VERSION:   1.03, 06-AUG-2018
           $LastChangedRevision: 466 $
********************************************************************/


#ifndef _CC_USER_CONFIG_H
#define _CC_USER_CONFIG_H


/********************************************************************
CANcrypt code selection
********************************************************************/

// If defined, monitor CAN for unexpected messages
// Not supported by this simplified demo
//#define Cc_USE_MONITORING

// If defined, implement grouping functionality
#define Cc_USE_GROUPING

// If defined, implement key generation and pairing functionality
// Not supported by this simplified demo
//#define Cc_USE_PAIRING

// If defined, implement secure messaging
#define Cc_USE_SECURE_MSG

// If defined, switch output pins for performance measurements,
// as well as for debug and test
#define Cc_USE_DIGOUT


/********************************************************************
Security CAN Functionality
Cc_SECFCT_BASIC           0x00
Cc_SECFCT_REGULAR         0x01
Cc_SECFCT_ADVANCED        0x02
Cc_SECFCT_CUSTOM          0x03
********************************************************************/
#define Cc_FUNCTIONALITY        Cc_SECFCT_REGULAR


/********************************************************************
Permanent key length used by this version: 128, 256 or 512
Must be greater or equal to the dynamic key length
********************************************************************/
#define Cc_PERMKEY_LEN_BITS     256
#define Cc_PERMKEY_LEN32        (Cc_PERMKEY_LEN_BITS >> 5)
#define Cc_PERMKEY_LEN8         (Cc_PERMKEY_LEN_BITS >> 3)
// Default permanent key available
#define Cc_PERMKEY_DEFAULT      Cc_PERM_KEY_USER


/********************************************************************
Dynamic key length used by this version: 64 or 128
********************************************************************/
#define Cc_KEY_LEN_BITS         128
#define Cc_KEY_LEN32            (Cc_KEY_LEN_BITS >> 5)
#define Cc_KEY_LEN16            (Cc_KEY_LEN_BITS >> 4)
#define Cc_KEY_LEN8             (Cc_KEY_LEN_BITS >> 3)


// Default length for key/bit generation cycle (<= 32)
//#define Cc_KEY_LEN_INIT         32


/********************************************************************
Timings used
IN THIS VERSION, INDIVIDUAL TIMINGS MUST STILL BE SET BELOW
********************************************************************/
#define Cc_TIMINGS              Cc_TIMING_MEDIUM


/********************************************************************
Secure heartbeat timings
********************************************************************/
// Secure Heartbeat event time
#define Cc_SECHB_EVENT_TIME     500

// Secure Heartbeat inhibit time
#define Cc_SECHB_INHIBIT_TIME   250

// Secure Heartbeat timeout
#define Cc_SECHB_TIMEOUT        1000

// Message sequence counter increment value, ensure multiple bits change
#define Cc_SEC_INC              0x0861

/********************************************************************
Default key generation parameters
********************************************************************/
// Bit generation method used: random delay or direct
#define Cc_BITMETHOD            Cc_BITMETHOD_DELAY

// Number of bit claiming messages used: 2 (default) or 16
#define Cc_BITMETHOD_CLAIMS     Cc_BITMETHOD_16CLAIMS

// Maximum number of ignore states allowed for bit select cycles
#if (Cc_BITMETHOD_CLAIMS == Cc_BITMETHOD_16CLAIMS)
 #define Cc_MAX_ignore_cnt       4
#else
 #define Cc_MAX_ignore_cnt       12
#endif

// CANcrypt Method combination
#define Cc_METHOD               ( Cc_TIMINGS + \
     (((Cc_BITMETHOD + Cc_BITMETHOD_CLAIMS + Cc_FUNCTIONALITY) << 4)) )

// Custom bit generation cycle timeout
#define Cc_CUST_BITCYC_TIMEOUT   20

// Custom bit generation max random delay time, 0 for immediate/direct 
#define Cc_CUST_BITCYC_RANDTIME  0x0F


/********************************************************************
Enable monitoring of unexpected CAN message IDs received.
********************************************************************/
// Maximum number of CAN IDs in list monitored, 0 to disable
#define Cc_CANIDLIST_LEN        16


/********************************************************************
CAN IDs used
********************************************************************/
// CANcrypt messages for devices and configurator, plus next 15 IDs
#define Cc_CANID_CONFIG         0x0171
// Bit claiming messages start with this ID, plus next 1 or 15 IDs

#define Cc_CANID_BITBASE        0x06F0

// CANcrypt messages for debug messages, plus next 15 IDs
#define Cc_CANID_DEBUG          0x06E1


/********************************************************************
Size of event queue for call backs (used from Rx thread)
Limit selection to 4 or 8
********************************************************************/
#define Cc_CBEVENT_QUEUE          0x04


/********************************************************************
DEFINES: CAN HARDWARE DRIVER DEFINITIONS
********************************************************************/

// Tx FIFO depth (must be 0, 4, 8, 16 or 32)
#define TXFIFOSIZE              16

// Rx FIFO depth (must be 0, 4, 8, 16 or 32)
#define RXFIFOSIZE              16


/********************************************************************
DEFINES: FOR DEVICES, ELIMINATE CONFIGURATOR CODE
********************************************************************/
#if (Cc_DEVICE_ID == 1)
  #define Cc_USE_DEVICE_ONLY 0
#else
  #define Cc_USE_DEVICE_ONLY 1
#endif

#endif
/*----------------------- END OF FILE -----------------------------*/
