/********************************************************************
MODULE:    CANcrypt_nvol.h, access to non volatile memory
CONTAINS:  Functions that access data stored in NVOL memory
AUTHORS:   Embedded Systems Academy, Inc (USA) and
           Embedded Systems Academy, GmbH (Germany)
HOME:      https://www.cancrypt.net
LICENSE:   See below, APPLIES TO THIS FILE ONLY. 
           See individual file headers for applicable license.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
  implied. See the License for the specific language governing 
  permissions and limitations under the License.

VERSION:   1.03, 06-AUG-2018
           $LastChangedRevision: 466 $
********************************************************************/



#ifndef _CANCRYPT_NVOL_H
#define _CANCRYPT_NVOL_H

#include "CANcrypt_types.h"


/********************************************************************
DOES:    This function retrieves the last saved grouping parameters
RETURNS: Both my_addr and grp_info
********************************************************************/
void Ccnvol_GetGroupInfo(
  UNSIGNED8 *my_addr,   // address (1-15) to use by this device
  UNSIGNED16 *grp_mand, // Mandatory devices to start up
                        // bits 1-15 set for each device in group
                        // bit 0 set if grouping is disabled
  UNSIGNED16 *grp_opt   // Optional devices to start up
                        // bits 1-15 set for each device in group
                        // bit 0 set if grouping is disabled
);


/********************************************************************
DOES:    This function saves the current grouping parameters
RETURNS: TRUE, if saved, FALSE if failed
********************************************************************/
UNSIGNED8 Ccnvol_SaveGroupInfo(
  UNSIGNED8 my_addr,    // address (1-15) to use by this device
  UNSIGNED16 grp_info   // bits 1-15 set for each device in group
                        // bit 0 set if grouping is disabled
);


/********************************************************************
BOOK:    Section 6.1 "Key hierarchy access"
DOES:    This function directly returns a key from the key hierarchy
RETURNS: Pointer to the key or NULL if not available
********************************************************************/
UNSIGNED32 *Ccnvol_GetPermKey(
  UNSIGNED8 key_mayor_ID        // key major ID
);


/**************************************************************************
BOOK:    Section 6.1 "Key hierarchy access"
DOES:    This function returns a key identifier from the key hierarchy
RETURNS: 0 if not available, else 32bit unique key identifier
**************************************************************************/
UNSIGNED32 Ccnvol_GetPermKeyID(
  UNSIGNED8 key_mayor_ID        // key major ID
);


/**************************************************************************
BOOK:    Section 6.1 "Key hierarchy access"
DOES:    This function writes a key identifier into the key hierarchy
RETURNS: TRUE when saved, else FALSE
**************************************************************************/
UNSIGNED8 Ccnvol_SavePermKeyID(
  UNSIGNED8 key_major_ID,       // key major ID
  UNSIGNED32 key_unique_ID      // unique 32bit key ID
);


/********************************************************************
BOOK:    Section 6.1 "Key hierarchy access"
DOES:    This function erases a key from the key hierarchy. Will only
         be called from CANcrypt, if called from authorized 
         configurator.
RETURNS: TRUE, if key was erased, else FALSE
********************************************************************/
UNSIGNED8 Ccnvol_ErasePermKey(
  UNSIGNED8 key_major_ID        // key major ID, 2 to 6
);


/********************************************************************
BOOK:    Section 6.1 "Key hierarchy access"
DOES:    This function saves a key to the key hierarchy. Will only
         be called from CANcrypt, if called from authorized 
         configurator.
RETURNS: TRUE, if key was erased, else FALSE
********************************************************************/
UNSIGNED8 Ccnvol_SavePermKey(
  UNSIGNED8 key_major_ID,       // key major ID, 2 to 6
  UNSIGNED32 *pkey              // pointer to key data
);

#endif
/*----------------------- END OF FILE -----------------------------*/

