/********************************************************************
MODULE:    CANcrypt_hwsys.h, Misc HW system functions
CONTAINS:  Random number generation and timers
AUTHORS:   Embedded Systems Academy, Inc (USA) and
           Embedded Systems Academy, GmbH (Germany)
HOME:      https://www.cancrypt.net
LICENSE:   See below, APPLIES TO THIS FILE ONLY. 
           See individual file headers for applicable license.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
  implied. See the License for the specific language governing 
  permissions and limitations under the License.

VERSION:   1.03, 06-AUG-2018
           $LastChangedRevision: 466 $
********************************************************************/


#ifndef _CANCRYPT_HWSYS_H
#define _CANCRYPT_HWSYS_H


#include "Cc_user_types.h"


/********************************************************************
DOES:    Generates a random value.
NOTE:    Must be suitable for security use, shall not produce the 
         same sequence of numbers on every reset or power up!!
RETURNS: Random value
********************************************************************/
UNSIGNED32 CCHW_Rand(
  void
);

  
/********************************************************************
DOES:    This function reads a 1 millisecond timer tick. The timer 
         tick must be a UNSIGNED16 and must be incremented once per 
         millisecond.
RETURNS: 1 millisecond timer tick
********************************************************************/
CC_TIMER_TYPE CCHW_GetTime (
  void
  );


/********************************************************************
DOES:    This function compares a UNSIGNED16 timestamp to the 
         internal timer tick and returns 1 if the timestamp 
         expired/passed.
RETURNS: 1 if timestamp expired/passed
         0 if timestamp is not yet reached
NOTES:   The maximum timer runtime measurable is 0x7FFF
********************************************************************/
UNSIGNED8 CCHW_IsTimeExpired (
  CC_TIMER_TYPE timestamp // Timestamp to be checked for expiration
  );


#endif
/*----------------------- END OF FILE -----------------------------*/
